/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.property;

import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.api.VWReceiveInstruction;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.property.VWReceiveParamPanel;
import filenet.vw.toolkit.runtime.property.resources.VWResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class VWReceiveAdvancedPanel
extends JPanel {
    private VWReceiveParamPanel m_parent = null;
    private VWInstructionDefinition m_instructionDef = null;
    private JTextField m_timeOutExpression = null;
    private JTextField m_timeOutMap = null;
    private JTextField m_authentication = null;
    private JList m_securityGroupList = null;

    public VWReceiveAdvancedPanel(VWReceiveParamPanel parent, VWInstructionDefinition instruction) {
        this.m_parent = parent;
        this.m_instructionDef = instruction;
        this.setupLayout();
    }

    public void setInstructionDefinition(VWReceiveInstruction instructionDef) {
        this.m_instructionDef = instructionDef;
        this.reinitialize();
    }

    private void setupLayout() {
        this.setLayout(new GridBagLayout());
        JLabel timeOutExpressionLabel = new JLabel(VWResource.s_timeOutExpressionColon);
        this.m_timeOutExpression = new JTextField();
        this.m_timeOutExpression.setEditable(false);
        this.m_timeOutExpression.setBorder(null);
        JPanel timeOutExpressionPanel = new JPanel(new BorderLayout(10, 0));
        timeOutExpressionPanel.add((Component)timeOutExpressionLabel, "Before");
        timeOutExpressionPanel.add((Component)this.m_timeOutExpression, "Center");
        JLabel timeOutMapLabel = new JLabel(VWResource.s_timeOutMapColon);
        this.m_timeOutMap = new JTextField();
        this.m_timeOutMap.setEditable(false);
        this.m_timeOutMap.setBorder(null);
        JPanel timeOutMapPanel = new JPanel(new BorderLayout(10, 0));
        timeOutMapPanel.add((Component)timeOutMapLabel, "Before");
        timeOutMapPanel.add((Component)this.m_timeOutMap, "Center");
        JLabel authenticationLabel = new JLabel(VWResource.s_authenticationColon);
        this.m_authentication = new JTextField();
        this.m_authentication.setEditable(false);
        this.m_authentication.setBorder(null);
        JPanel authenticationPanel = new JPanel(new BorderLayout(10, 0));
        authenticationPanel.add((Component)authenticationLabel, "Before");
        authenticationPanel.add((Component)this.m_authentication, "Center");
        JLabel securityGroupLabel = new JLabel(VWResource.s_acceptMessagesFrom);
        this.m_securityGroupList = new JList();
        this.m_securityGroupList.setEnabled(false);
        this.m_securityGroupList.setBorder(null);
        JPanel workflowGroupPanel = new JPanel(new BorderLayout(10, 0));
        workflowGroupPanel.add((Component)securityGroupLabel, "Before");
        workflowGroupPanel.add((Component)new JScrollPane(this.m_securityGroupList), "Center");
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 23;
        c.gridwidth = 0;
        c.fill = 2;
        this.add((Component)timeOutExpressionPanel, c);
        ++c.gridy;
        this.add((Component)timeOutMapPanel, c);
        ++c.gridy;
        this.add((Component)authenticationPanel, c);
        ++c.gridy;
        c.weighty = 1.0;
        this.add((Component)workflowGroupPanel, c);
    }

    private void reinitialize() {
        try {
            String timeOutExpression = ((VWReceiveInstruction)this.m_instructionDef).getTimeoutExpr();
            this.m_parent.setTextField(this.m_timeOutExpression, timeOutExpression);
            String timeOutMap = ((VWReceiveInstruction)this.m_instructionDef).getTimeoutMapName();
            this.m_parent.setTextField(this.m_timeOutMap, timeOutMap);
            boolean bAuthentication = ((VWReceiveInstruction)this.m_instructionDef).getAuthentication();
            String sAuthentication = null;
            sAuthentication = bAuthentication ? VWResource.s_true : VWResource.s_false;
            this.m_parent.setTextField(this.m_authentication, sAuthentication);
            String[] names = ((VWReceiveInstruction)this.m_instructionDef).getSecurityGroup();
            if (names != null) {
                this.m_securityGroupList.setListData(names);
            }
            this.updateUI();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void removeReferences() {
        this.m_timeOutExpression = null;
        this.m_timeOutMap = null;
        this.m_authentication = null;
        this.m_securityGroupList = null;
        this.m_parent = null;
        this.m_instructionDef = null;
    }
}

